/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.XmlSerializer;
import org.basex.build.html.HtmlOptions;
import org.basex.build.xml.XMLParser;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.item.QNm;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.ccil.cowan.tagsoup.XMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class HtmlParser
extends XMLParser {
    public HtmlParser(IO source, MainOptions options, HtmlOptions hopts) throws IOException {
        this(source, Parser.of(hopts), options, hopts);
    }

    public HtmlParser(IO source, Parser parser, MainOptions options, HtmlOptions hopts) throws IOException {
        super(HtmlParser.toXml(source, parser, hopts), options);
    }

    private static IO toXml(IO io, Parser parser, HtmlOptions hopts) throws IOException {
        if (parser == null) {
            return io;
        }
        try {
            StringWriter sw = new StringWriter();
            XMLReader reader = parser.reader(hopts, sw);
            try (InputStream in = io.inputStream();){
                String enc;
                InputSource is = new InputSource(in);
                String string = enc = io.encoding() != null ? io.encoding() : hopts.get(HtmlOptions.ENCODING);
                if (enc != null) {
                    if (!Strings.encodingSupported(enc)) {
                        throw QueryError.INVALIDOPTION_X.getIO("Unknown encoding: " + enc + ".");
                    }
                    is.setEncoding(Strings.normEncoding(enc));
                }
                reader.parse(is);
            }
            return new IOContent(Token.token(sw.toString()), io.name());
        }
        catch (SAXException ex) {
            Util.errln(ex, new Object[0]);
            throw QueryError.INVHTML_X.getIO(ex.getLocalizedMessage());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Parser {
        TAGSOUP("TagSoup", new String[]{"org.ccil.cowan.tagsoup.Parser"}){
            private static final String FEATURES = "http://www.ccil.org/~cowan/tagsoup/features/";

            @Override
            XMLReader reader(HtmlOptions hopts, StringWriter sw) throws SAXException {
                org.ccil.cowan.tagsoup.Parser reader = new org.ccil.cowan.tagsoup.Parser();
                XMLWriter writer = new XMLWriter((Writer)sw);
                writer.setOutputProperty(HtmlOptions.ENCODING.name(), "UTF-8");
                reader.setContentHandler((ContentHandler)writer);
                if (hopts.get(HtmlOptions.NONS).booleanValue()) {
                    reader.setFeature("http://xml.org/sax/features/namespaces", false);
                }
                if (hopts.get(HtmlOptions.NOBOGONS).booleanValue()) {
                    reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
                }
                if (hopts.get(HtmlOptions.NODEFAULTS).booleanValue()) {
                    reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/default-attributes", false);
                }
                if (hopts.get(HtmlOptions.NOCOLONS).booleanValue()) {
                    reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/translate-colons", true);
                }
                if (hopts.get(HtmlOptions.NORESTART).booleanValue()) {
                    reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/restart-elements", false);
                }
                if (hopts.get(HtmlOptions.IGNORABLE).booleanValue()) {
                    reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignorable-whitespace", true);
                }
                if (hopts.get(HtmlOptions.EMPTYBOGONS).booleanValue()) {
                    reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", true);
                }
                if (hopts.get(HtmlOptions.ANY).booleanValue()) {
                    reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", false);
                }
                if (hopts.get(HtmlOptions.NOROOTBOGONS).booleanValue()) {
                    reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/root-bogons", false);
                }
                if (hopts.get(HtmlOptions.NOCDATA).booleanValue()) {
                    reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/cdata-elements", false);
                }
                if (hopts.get(HtmlOptions.LEXICAL).booleanValue()) {
                    reader.setProperty("http://xml.org/sax/properties/lexical-handler", writer);
                }
                if (hopts.get(HtmlOptions.OMIT_XML_DECLARATION).booleanValue()) {
                    writer.setOutputProperty(HtmlOptions.OMIT_XML_DECLARATION.name(), "yes");
                }
                if (hopts.contains(HtmlOptions.DOCTYPE_SYSTEM)) {
                    writer.setOutputProperty(HtmlOptions.DOCTYPE_SYSTEM.name(), hopts.get(HtmlOptions.DOCTYPE_SYSTEM));
                }
                if (hopts.contains(HtmlOptions.DOCTYPE_PUBLIC)) {
                    writer.setOutputProperty(HtmlOptions.DOCTYPE_PUBLIC.name(), hopts.get(HtmlOptions.DOCTYPE_PUBLIC));
                }
                return reader;
            }
        }
        ,
        NU("Validator.nu", new String[]{"nu.validator.htmlparser.sax.HtmlParser", "nu.validator.htmlparser.sax.XmlSerializer", "nu.validator.htmlparser.common.XmlViolationPolicy", "nu.validator.htmlparser.common.Heuristics"}){
            private static final String ICU_CLASS_NAME = "com.ibm.icu.text.CharsetDetector";
            private static final String CHARDET_CLASS_NAME = "org.mozilla.intl.chardet.nsICharsetDetectionObserver";

            @Override
            XMLReader reader(HtmlOptions hopts, StringWriter sw) throws SAXException {
                nu.validator.htmlparser.sax.HtmlParser reader = new nu.validator.htmlparser.sax.HtmlParser(XmlViolationPolicy.ALTER_INFOSET);
                XmlSerializer writer = new XmlSerializer((Writer)sw);
                reader.setContentHandler((ContentHandler)writer);
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)writer);
                if (hopts.get(HtmlOptions.UNICODE_NORMALIZATION_CHECKING).booleanValue()) {
                    reader.setCheckingNormalization(true);
                }
                if (hopts.get(HtmlOptions.MAPPING_LANG_TO_XML_LANG).booleanValue()) {
                    reader.setMappingLangToXmlLang(true);
                }
                if (hopts.get(HtmlOptions.SCRIPTING_ENABLED).booleanValue()) {
                    reader.setScriptingEnabled(true);
                }
                if (hopts.contains(HtmlOptions.CONTENT_SPACE_POLICY)) {
                    reader.setContentSpacePolicy(XmlViolationPolicy.valueOf((String)hopts.get(HtmlOptions.CONTENT_SPACE_POLICY).name()));
                }
                if (hopts.contains(HtmlOptions.CONTENT_NON_XML_CHAR_POLICY)) {
                    reader.setContentNonXmlCharPolicy(XmlViolationPolicy.valueOf((String)hopts.get(HtmlOptions.CONTENT_NON_XML_CHAR_POLICY).name()));
                }
                if (hopts.contains(HtmlOptions.COMMENT_POLICY)) {
                    reader.setCommentPolicy(XmlViolationPolicy.valueOf((String)hopts.get(HtmlOptions.COMMENT_POLICY).name()));
                }
                if (hopts.contains(HtmlOptions.XMLNS_POLICY)) {
                    reader.setXmlnsPolicy(XmlViolationPolicy.valueOf((String)hopts.get(HtmlOptions.XMLNS_POLICY).name()));
                }
                if (hopts.contains(HtmlOptions.NAME_POLICY)) {
                    reader.setNamePolicy(XmlViolationPolicy.valueOf((String)hopts.get(HtmlOptions.NAME_POLICY).name()));
                }
                if (hopts.contains(HtmlOptions.STREAMABILITY_VIOLATION_POLICY)) {
                    reader.setStreamabilityViolationPolicy(XmlViolationPolicy.valueOf((String)hopts.get(HtmlOptions.STREAMABILITY_VIOLATION_POLICY).name()));
                }
                if (hopts.contains(HtmlOptions.XML_POLICY)) {
                    reader.setXmlPolicy(XmlViolationPolicy.valueOf((String)hopts.get(HtmlOptions.XML_POLICY).name()));
                }
                if (hopts.contains(HtmlOptions.HEURISTICS)) {
                    reader.setHeuristics(Heuristics.valueOf((String)hopts.get(HtmlOptions.HEURISTICS).name()));
                }
                return reader;
            }

            @Override
            public void ensureAvailable(HtmlOptions options, QNm name, InputInfo info) throws QueryException {
                super.ensureAvailable(options, name, info);
                if (options.contains(HtmlOptions.HEURISTICS)) {
                    switch (options.get(HtmlOptions.HEURISTICS)) {
                        case ALL: {
                            2.ensureAvailable(ICU_CLASS_NAME, name, info);
                            2.ensureAvailable(CHARDET_CLASS_NAME, name, info);
                            break;
                        }
                        case ICU: {
                            2.ensureAvailable(ICU_CLASS_NAME, name, info);
                            break;
                        }
                        case CHARDET: {
                            2.ensureAvailable(CHARDET_CLASS_NAME, name, info);
                            break;
                        }
                    }
                }
            }

            @Override
            public boolean available(HtmlOptions options) {
                if (!super.available(options)) {
                    return false;
                }
                if (!options.contains(HtmlOptions.HEURISTICS)) {
                    return true;
                }
                switch (options.get(HtmlOptions.HEURISTICS)) {
                    case ALL: {
                        if (!Reflect.available(ICU_CLASS_NAME, new Object[0])) {
                            return false;
                        }
                        if (Reflect.available(CHARDET_CLASS_NAME, new Object[0])) break;
                        return false;
                    }
                    case ICU: {
                        if (Reflect.available(ICU_CLASS_NAME, new Object[0])) break;
                        return false;
                    }
                    case CHARDET: {
                        if (Reflect.available(CHARDET_CLASS_NAME, new Object[0])) break;
                        return false;
                    }
                }
                return true;
            }
        };

        public static final Parser DEFAULT;
        private final String string;
        private final String[] classes;

        abstract XMLReader reader(HtmlOptions var1, StringWriter var2) throws SAXException;

        private Parser(String string2, String ... classes) {
            this.string = string2;
            this.classes = classes;
        }

        public boolean available(HtmlOptions options) {
            for (String cl : this.classes) {
                if (Reflect.available(cl, new Object[0])) continue;
                return false;
            }
            return true;
        }

        public void ensureAvailable(HtmlOptions options, QNm name, InputInfo info) throws QueryException {
            for (String cl : this.classes) {
                Parser.ensureAvailable(cl, name, info);
            }
        }

        static void ensureAvailable(String className, QNm name, InputInfo info) throws QueryException {
            if (!Reflect.available(className, new Object[0])) {
                throw QueryError.BASEX_CLASSPATH_X_X.get(info, name, className);
            }
        }

        public static Parser of(HtmlOptions options) {
            return Parser.of(options, DEFAULT);
        }

        public static Parser of(HtmlOptions options, Parser parser) {
            return options.contains(HtmlOptions.METHOD) ? options.get(HtmlOptions.METHOD).parser : parser;
        }

        public String toString() {
            return this.string;
        }

        static {
            HtmlOptions opts = new HtmlOptions();
            DEFAULT = TAGSOUP.available(opts) ? TAGSOUP : (NU.available(opts) ? NU : null);
        }
    }

    public static enum Method {
        tagsoup(Parser.TAGSOUP),
        nu(Parser.NU);

        public final Parser parser;

        private Method(Parser parser) {
            this.parser = parser;
        }
    }
}

