/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.basex.BaseXServer;
import org.basex.api.client.ClientSession;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.cmd.Set;
import org.basex.core.jobs.JobException;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerMode;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryProcessor;
import org.basex.query.func.Function;
import org.basex.query.func.prof.ProfType;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FNode;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.options.Option;
import org.junit.jupiter.api.Assertions;

public abstract class Sandbox {
    private static final boolean OUTPUT = false;
    private static final String BASEURI = new File(".").getAbsolutePath();
    protected static final int DB_PORT = 9996;
    protected static final int STOP_PORT = 9999;
    protected static final int HTTP_PORT = 9998;
    protected static final String REST = "rest";
    protected static final String HTTP_ROOT = "http://localhost:9998/";
    protected static final String REST_ROOT = "http://localhost:9998/rest/";
    protected static final PrintStream OUT = System.out;
    protected static final PrintStream ERR = System.err;
    protected static final String NAME = Util.className(Sandbox.class);
    protected static Context context;

    protected static String execute(Command cmd) {
        try {
            return cmd.execute(context);
        }
        catch (BaseXException ex) {
            Util.stack(ex);
            return (String)Assertions.fail((Throwable)ex);
        }
    }

    protected static void set(Option<?> option, Object value) {
        Sandbox.execute(new Set(option.name(), value));
    }

    protected static String query(String query) {
        try {
            return Sandbox.eval(query);
        }
        catch (JobException ex) {
            Util.debug(ex);
            return "";
        }
        catch (IOException | QueryException ex) {
            Util.stack(ex);
            return (String)Assertions.fail((String)("Query failed:\n" + query), (Throwable)ex);
        }
    }

    protected static void query(String query, Object expected) {
        Sandbox.compare(query, Sandbox.query(query), expected, null);
    }

    protected static void compare(String query, String result, Object expected, ANode plan) {
        String res = Sandbox.normNL(result);
        String exp = expected.toString();
        if (!exp.equals(res)) {
            Assertions.fail((String)("\n" + query + "\n[EXPECT] " + exp + "\n[RESULT] " + res + (String)(plan == null ? "" : "\n" + Sandbox.serialize(plan))));
        }
    }

    protected static String serialize(ANode plan) {
        try {
            return plan != null ? "PLAN: " + String.valueOf(plan.serialize(SerializerMode.INDENT.get())) : "";
        }
        catch (QueryIOException ex) {
            return (String)Assertions.fail((Throwable)ex);
        }
    }

    protected static String transform(String input, String modify, String rtrn) {
        return "copy $input := " + input + " modify (" + modify + ") return (" + (rtrn.isEmpty() ? "$input" : rtrn) + ")";
    }

    protected static String transform(String input, String modification) {
        return Sandbox.transform(input, modification, "");
    }

    protected static void contains(String query, String result) {
        String res = Sandbox.normNL(Sandbox.query(query));
        if (!res.contains(result)) {
            Assertions.fail((String)("Result does not contain substring: " + result + "\n" + query + "\n[E] " + result + "\n[F] " + res));
        }
    }

    protected static void error(String query, QueryError ... error) {
        try {
            String res = Sandbox.eval(query);
            TokenBuilder tb = new TokenBuilder().add("Query did not fail:\n");
            tb.add(query).add("\n[E] Error: ");
            for (QueryError e : error) {
                tb.add(32).add(e.qname().prefixId());
            }
            Assertions.fail((String)tb.add("\n[F] ").add(res).toString());
        }
        catch (QueryIOException ex) {
            Sandbox.error(query, ex.getCause(), error);
        }
        catch (QueryException ex) {
            Sandbox.error(query, ex, error);
        }
        catch (Exception ex) {
            Util.stack(ex);
            Assertions.fail((Throwable)ex);
        }
    }

    protected static void error(String query, QueryException ex, QueryError ... errors) {
        boolean found = false;
        QueryError err = ex.error();
        for (QueryError e : errors) {
            found |= err != null ? err == e : e.qname().eq(ex.qname());
        }
        if (!found) {
            TokenBuilder tb = new TokenBuilder().add(10);
            if (query != null) {
                tb.add("Query: ").add(query).add(10);
            }
            tb.add("Error(s): ");
            if (err != null) {
                Util.stack(ex);
                c = 0;
                for (QueryError er : errors) {
                    tb.add(c++ == 0 ? "" : "/").add(er.name());
                }
                tb.add("\nResult: ").add(err.name() + " (" + ex.getLocalizedMessage() + ")");
            } else {
                c = 0;
                for (QueryError er : errors) {
                    if (c++ > 0) {
                        tb.add(47);
                    }
                    tb.add(er.qname().local());
                }
                tb.add("\nResult: ").add(ex.qname().string());
            }
            Assertions.fail((String)tb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String eval(String query) throws QueryException, IOException {
        ArrayOutput ao = new ArrayOutput();
        try (QueryProcessor qp = new QueryProcessor(query, BASEURI, context, null);){
            qp.compile();
            qp.register(context);
            try (Serializer ser = qp.serializer(ao);){
                qp.value().serialize(ser);
            }
            finally {
                qp.close();
                qp.unregister(context);
            }
        }
        return ao.toString();
    }

    protected static void check(String query, Object expected, String ... tests) {
        try (QueryProcessor qp = new QueryProcessor(query, context);){
            qp.optimize();
            FNode plan = qp.toXml();
            if (expected != null) {
                Sandbox.compare(query, qp.value().serialize().toString(), expected, plan);
            }
            for (String test : tests) {
                FNode doc = FDoc.build().add(plan).finish();
                try (QueryProcessor qp2 = new QueryProcessor(test, context).context(doc);){
                    if (qp2.value() == Bln.TRUE) continue;
                    Assertions.fail((String)(Prop.NL + "QUERY: " + query + Prop.NL + "OPTIMIZED: " + String.valueOf(qp.qc.main) + Prop.NL + "TEST: " + test + Prop.NL + Sandbox.serialize(plan)));
                }
            }
        }
        catch (QueryException | QueryIOException ex) {
            Util.stack(ex);
            Assertions.fail((Throwable)ex);
        }
    }

    protected static void checkType(String query, ProfType.TypeInfo expr) {
        Sandbox.checkType(query, expr.toString());
    }

    protected static void checkType(String query, ProfType.TypeInfo expr, ProfType.TypeInfo result) {
        Sandbox.checkType(query, String.valueOf(expr) + " -> " + String.valueOf(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkType(String query, String type) {
        try (ArrayOutput ao = new ArrayOutput();){
            System.setErr(new PrintStream(ao));
            Sandbox.query(Function._PROF_TYPE.args(" " + query));
            String returned = Token.string(ao.next()).trim();
            Assertions.assertEquals((Object)type, (Object)returned, (String)("\nExpected: " + type + "\nReturned: " + returned));
        }
        finally {
            System.setErr(ERR);
        }
    }

    protected static String empty(String expr) {
        return "empty(//" + expr + ")";
    }

    protected static String empty(Class<?> clazz) {
        return Sandbox.empty(Util.className(clazz));
    }

    protected static String empty(Function func) {
        return Sandbox.empty(func.className());
    }

    protected static String exists(String expr) {
        return "exists(//" + expr + ")";
    }

    protected static String exists(Class<?> clazz) {
        return Sandbox.exists(Util.className(clazz));
    }

    protected static String exists(Function func) {
        return Sandbox.exists(func.className());
    }

    protected static String empty() {
        return Sandbox.root("Empty");
    }

    protected static String root(String expr) {
        return "QueryPlan/* ! name() = '" + expr + "'";
    }

    protected static String root(Function func) {
        return Sandbox.root(func.className());
    }

    protected static String root(Class<?> clazz) {
        return Sandbox.root(Util.className(clazz));
    }

    protected static String count(Class<?> clazz, int count) {
        return Sandbox.count(Util.className(clazz), count);
    }

    protected static String count(Function func, int count) {
        return Sandbox.count(func.className(), count);
    }

    protected static String count(String expr, int count) {
        return "count(//" + expr + ") = " + count;
    }

    protected static String type(String name, String type) {
        return "string(//" + name + "/@type) = '" + type + "'";
    }

    protected static String type(Class<?> clazz, String type) {
        return Sandbox.type(Util.className(clazz), type);
    }

    protected static String type(Function func, String type) {
        return Sandbox.type(func.className(), type);
    }

    protected static void write(IOFile file, String data) {
        try {
            file.write(data);
        }
        catch (IOException ex) {
            Util.stack(ex);
            Assertions.fail((Throwable)ex);
        }
    }

    public static void initSandbox() {
        IOFile sb = Sandbox.sandbox();
        if (!sb.md()) {
            Assertions.fail((String)"Sandbox could not be created.");
        }
        String path = sb.path();
        Prop.put(StaticOptions.DBPATH, path + "/data");
        Prop.put(StaticOptions.WEBPATH, path + "/webapp");
        Prop.put(StaticOptions.RESTXQPATH, path + "/webapp");
        Prop.put(StaticOptions.REPOPATH, path + "/repo");
        Prop.put(StaticOptions.SERVERPORT, Integer.toString(9996));
        context = new Context();
        Sandbox.context.options.set(MainOptions.UNROLLLIMIT, 0);
        Sandbox.context.options.set(MainOptions.INLINELIMIT, 0);
    }

    public static void finishSandbox() {
        context.close();
        Prop.clear();
        Properties props = System.getProperties();
        for (Object key : props.keySet()) {
            String path = key.toString();
            if (!path.startsWith("org.basex.")) continue;
            props.remove(key);
        }
        if (!Sandbox.sandbox().delete()) {
            Assertions.fail((String)"Sandbox could not be deleted.");
        }
    }

    protected static void inline(boolean enable) {
        Sandbox.context.options.set(MainOptions.INLINELIMIT, enable ? 65536 : 0);
    }

    protected static void unroll(boolean enable) {
        Sandbox.context.options.set(MainOptions.UNROLLLIMIT, enable ? 65536 : 0);
    }

    public static BaseXServer createServer(String ... args) throws IOException {
        StringList sl = new StringList("-p9996", "-z", "-c", "password " + NAME, "-q");
        BaseXServer server = new BaseXServer((String[])((StringList)sl.add(args)).finish());
        server.context.soptions.set(StaticOptions.DBPATH, Sandbox.sandbox().path());
        return server;
    }

    public static void stopServer(BaseXServer server) throws IOException {
        if (server != null) {
            server.stop();
        }
    }

    public static ClientSession createClient(String ... login) throws IOException {
        String username = login.length > 0 ? login[0] : "admin";
        String password = login.length > 1 ? login[1] : NAME;
        return new ClientSession("localhost", 9996, username, password);
    }

    public static IOFile sandbox() {
        return new IOFile(Prop.TEMPDIR, NAME + "/");
    }

    public static String normNL(String result) {
        return result.replaceAll("(\r?\n|\r)", "\n");
    }

    public static String wrapContext() {
        return " data(attribute _ { . })";
    }

    public static String wrap(Object value) {
        return " data(attribute _ { '" + String.valueOf(value) + "' })";
    }

    public static final class SandboxClient
    extends Thread {
        private final CountDownLatch startSignal;
        private final CountDownLatch stopSignal;
        private final ClientSession session = Sandbox.createClient(new String[0]);
        private final Command cmd;
        public String error;

        public SandboxClient(Command c, CountDownLatch start, CountDownLatch stop) throws IOException {
            this.cmd = c;
            this.startSignal = start;
            this.stopSignal = stop;
            this.start();
        }

        @Override
        public void run() {
            try {
                if (this.startSignal != null) {
                    this.startSignal.await();
                }
                this.session.execute(this.cmd);
                this.session.close();
            }
            catch (Throwable ex) {
                this.error = "\n" + String.valueOf(this.cmd) + "\n" + String.valueOf(ex);
            }
            finally {
                if (this.stopSignal != null) {
                    this.stopSignal.countDown();
                }
            }
        }
    }
}

