/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.SchemaFactory;
import org.basex.core.MainOptions;
import org.basex.util.Resolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlParser {
    private final XMLReader reader = XmlParser.reader(new MainOptions());

    public XmlParser contentHandler(ContentHandler handler) {
        this.reader.setContentHandler(handler);
        return this;
    }

    public void parse(InputStream stream) throws IOException, SAXException {
        this.reader.setErrorHandler(new XmlHandler());
        this.reader.parse(new InputSource(stream));
    }

    public static XMLReader reader(MainOptions options) throws SAXException, ParserConfigurationException {
        int entExpansion = options.get(MainOptions.ENTEXPANSION);
        boolean extEntities = options.get(MainOptions.EXTERNALENT);
        boolean dtd = options.get(MainOptions.DTD);
        boolean dtdValidation = options.get(MainOptions.DTDVALIDATION);
        boolean xinclude = options.get(MainOptions.XINCLUDE);
        boolean xsdValidation = "strict".equals(options.get(MainOptions.XSDVALIDATION));
        boolean xsiLocation = options.get(MainOptions.XSILOCATION);
        SAXParserFactory f = SAXParserFactory.newDefaultInstance();
        if (extEntities) {
            f.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", dtd);
            f.setFeature("http://xml.org/sax/features/external-general-entities", dtd);
            f.setFeature("http://xml.org/sax/features/external-parameter-entities", dtd);
        }
        f.setFeature("http://xml.org/sax/features/validation", dtdValidation);
        f.setFeature("http://xml.org/sax/features/use-entity-resolver2", false);
        f.setNamespaceAware(true);
        f.setValidating(dtdValidation);
        f.setXIncludeAware(xinclude);
        if (xsdValidation) {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            sf.setResourceResolver(Resolver.resources(options));
            f.setSchema(sf.newSchema());
        }
        XMLReader xr = f.newSAXParser().getXMLReader();
        if (entExpansion != -1) {
            xr.setProperty("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit", entExpansion);
        }
        if (xsdValidation && !xsiLocation || !extEntities) {
            xr.setEntityResolver((pubId, sysId) -> {
                throw new SAXException("External access not allowed: " + sysId);
            });
        }
        return xr;
    }

    private static final class XmlHandler
    extends DefaultHandler {
        private XmlHandler() {
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXParseException {
            throw ex;
        }

        @Override
        public void error(SAXParseException ex) throws SAXParseException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXParseException {
            throw ex;
        }
    }
}

