/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Unary
extends Single {
    private final boolean minus;

    public Unary(InputInfo info, Expr expr, boolean minus) {
        super(info, expr, SeqType.NUMERIC_ZO);
        this.minus = minus;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        SeqType st = this.expr.seqType();
        AtomType type = st.type.isUntyped() ? AtomType.DOUBLE : (st.type.instanceOf(AtomType.INTEGER) ? AtomType.INTEGER : st.type);
        Occ occ = st.oneOrMore() && !st.mayBeArray() ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE;
        this.exprType.assign(type, occ);
        if (!this.minus && st.instanceOf(SeqType.NUMERIC_ZO)) {
            Expr cast = new Cast(this.info, this.expr, SeqType.get(type, st.occ)).optimize(cc);
            return cc.replaceWith(this, cast);
        }
        return super.optimize(cc);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item = this.expr.atomItem(qc, this.info);
        if (item.isEmpty()) {
            return Empty.VALUE;
        }
        Type type = item.type;
        if (type.isUntyped()) {
            double d = item.dbl(this.info);
            return Dbl.get(this.minus ? -d : d);
        }
        if (!type.isNumber()) {
            throw QueryError.numberError(this, item);
        }
        if (!this.minus) {
            return item;
        }
        if (type == AtomType.DOUBLE) {
            return Dbl.get(-item.dbl(this.info));
        }
        if (type == AtomType.FLOAT) {
            return Flt.get(-item.flt(this.info));
        }
        if (type == AtomType.DECIMAL) {
            return Dec.get(item.dec(this.info).negate());
        }
        long l = item.itr(this.info);
        if (l == Long.MIN_VALUE) {
            throw QueryError.RANGE_X.get(this.info, item);
        }
        return Itr.get(-l);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Unary(this.info, this.expr.copy(cc, vm), this.minus));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Unary)) return false;
        Unary unry = (Unary)obj;
        if (this.minus != unry.minus) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public String description() {
        return "unary expression";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "value", this.minus), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        if (this.minus) {
            qs.token("-");
        }
        qs.token(this.expr);
    }
}

