/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.ArrayInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.bin.BinFn;
import org.basex.query.func.convert.ConvertFn;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;

public final class BinDecodeString
extends BinFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        String enc;
        Bin binary = this.toBinOrNull(this.arg(0), qc);
        String encoding = this.toEncodingOrNull(this.arg(1), QueryError.BIN_UE_X, qc);
        Item offset = this.arg(2).atomItem(qc, this.info);
        Item size = this.arg(3).atomItem(qc, this.info);
        if (binary == null) {
            return Empty.VALUE;
        }
        byte[] bytes = binary.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(offset, offset.isEmpty() ? Empty.VALUE : size, bl);
        int o = bounds[0];
        int tl = bounds[1];
        String string = enc = encoding == "UTF-16" && bl > 1 && bytes[0] == -1 && bytes[1] == -2 ? "UTF-16LE" : encoding;
        if (o > 0 || tl < bl) {
            bytes = Arrays.copyOfRange(bytes, o, o + tl);
        }
        try {
            return Str.get(ConvertFn.toString(new ArrayInput(bytes), enc, true));
        }
        catch (IOException ex) {
            throw QueryError.BIN_CE_X.get(this.info, ex);
        }
    }
}

