/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.basex.core.CommonOptions;
import org.basex.core.MainOptions;
import org.basex.core.users.Perm;
import org.basex.io.IOUrl;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryInput;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.DynamicFn;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.util.Token;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;

public abstract class Docs
extends DynamicFn {
    QueryInput queryInput;

    QueryInput queryInput(byte[] uri) {
        return this.queryInput != null ? this.queryInput : (Uri.get(uri).isValid() ? new QueryInput(Token.string(uri), this.sc()) : null);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr expr;
        if (cc.dynamic && (expr = this.arg(0)) instanceof Value) {
            Value value = (Value)expr;
            Item item = value.atomItem(cc.qc, this.info);
            if (item.isEmpty()) {
                return this.value(cc.qc);
            }
            this.queryInput = this.queryInput(this.toToken(item));
            if (this.queryInput == null || !(this.queryInput.io instanceof IOUrl)) {
                return this.value(cc.qc);
            }
        }
        return this;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.lock(() -> {
            ArrayList<String> list = new ArrayList<String>(1);
            if (this.sc().withdb) {
                if (this.defined(0)) {
                    byte[] uri;
                    Expr expr = this.arg(0);
                    if (expr instanceof Str) {
                        Str str = (Str)expr;
                        v0 = str.string();
                    } else if (expr instanceof Atm) {
                        Atm atm = (Atm)expr;
                        v0 = atm.string(null);
                    } else {
                        v0 = uri = null;
                    }
                    if (uri != null) {
                        this.queryInput = this.queryInput(uri);
                        if (this.queryInput != null && this.queryInput.dbName != null) {
                            list.add(this.queryInput.dbName);
                        }
                    } else {
                        list.add(expr.seqType().zero() ? "internal:collection" : null);
                    }
                } else {
                    list.add("internal:collection");
                }
            }
            return list;
        }) && super.accept(visitor);
    }

    void check(Options options, boolean fragment, QueryContext qc) throws QueryException {
        String xsdVal;
        boolean externalent;
        Predicate<BooleanOption> bool = o -> options.get((BooleanOption)o) == Boolean.TRUE;
        boolean dtd = bool.test(CommonOptions.DTD) || bool.test(MainOptions.DTD);
        boolean xinclude = bool.test(CommonOptions.XINCLUDE) || bool.test(MainOptions.XINCLUDE);
        boolean bl = externalent = bool.test(CommonOptions.ALLOW_EXTERNAL_ENTITIES) || bool.test(MainOptions.EXTERNALENT);
        if (dtd || xinclude || externalent) {
            this.checkPerm(qc, Perm.CREATE);
        }
        boolean intparse = fragment || bool.test(CommonOptions.INTPARSE) || bool.test(MainOptions.INTPARSE);
        boolean dtdVal = bool.test(CommonOptions.DTD_VALIDATION) || bool.test(MainOptions.DTDVALIDATION);
        String string = xsdVal = fragment ? "skip" : options.get(MainOptions.XSDVALIDATION);
        if (xsdVal == null) {
            xsdVal = options.get(CommonOptions.XSD_VALIDATION);
        }
        boolean skip = "skip".equals(xsdVal);
        boolean strict = "strict".equals(xsdVal);
        if (intparse) {
            if (dtdVal) {
                throw QueryError.NODTDVALIDATION.get(this.info, new Object[0]);
            }
            if (!skip) {
                throw QueryError.NOXSDVALIDATION_X.get(this.info, xsdVal);
            }
        } else if (!skip) {
            if (!strict) {
                throw QueryError.INVALIDXSDOPT_X.get(this.info, xsdVal);
            }
            if (dtdVal) {
                throw QueryError.NOXSDANDDTD_X.get(this.info, xsdVal);
            }
        }
    }
}

