/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import org.basex.build.Parser;
import org.basex.build.xml.SAXHandler;
import org.basex.build.xml.XMLParser;
import org.basex.core.CommonOptions;
import org.basex.core.MainOptions;
import org.basex.io.IOContent;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.Docs;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;
import org.xml.sax.SAXException;

public class FnParseXmlFragment
extends Docs {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.parse(qc, true, this.toOptions(this.arg(1), new ParseXmlFragmentOptions(), qc));
    }

    @Override
    protected final Expr opt(CompileContext cc) {
        return this.optFirst();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return FnParseXmlFragment.visitAll(visitor, this.exprs);
    }

    final Item parse(QueryContext qc, boolean fragment, Options options) throws QueryException {
        Item value = this.arg(0).atomItem(qc, this.info);
        if (value.isEmpty()) {
            return Empty.VALUE;
        }
        this.check(options, fragment, qc);
        String baseURI = options.contains(CommonOptions.BASE_URI) ? options.get(CommonOptions.BASE_URI) : Token.string(this.sc().baseURI().string());
        String encoding = value instanceof Bin ? null : "UTF-8";
        IOContent io = new IOContent(this.toBytes(value), baseURI, encoding);
        MainOptions mopts = new MainOptions(options);
        mopts.set(MainOptions.CATALOG, qc.context.options.get(MainOptions.CATALOG));
        try {
            boolean ip = fragment || mopts.get(MainOptions.INTPARSE) != false;
            return new DBNode(ip ? new XMLParser(io, mopts, fragment) : Parser.xmlParser(io, mopts));
        }
        catch (IOException ex) {
            QueryException qe;
            Throwable th = ex.getCause();
            QueryException queryException = !(th instanceof SAXHandler.ValidationException) ? QueryError.SAXERR_X.get(this.info, ex) : (qe = mopts.get(MainOptions.DTDVALIDATION) != false ? QueryError.DTDVALIDATIONERR_X.get(this.info, ex) : QueryError.XSDVALIDATIONERR_X.get(this.info, ex));
            if (th instanceof SAXException) {
                qe.value(Str.get(th.toString()));
            }
            throw qe;
        }
    }

    public static class ParseXmlFragmentOptions
    extends Options {
        public static final StringOption BASE_URI = CommonOptions.BASE_URI;
        public static final BooleanOption STRIP_SPACE = CommonOptions.STRIP_SPACE;
        public static final BooleanOption STRIPNS = CommonOptions.STRIPNS;
    }
}

