/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Atm
extends Item {
    public static final Atm EMPTY = new Atm(Token.EMPTY);
    private final byte[] value;

    private Atm(byte[] value) {
        super(AtomType.UNTYPED_ATOMIC);
        this.value = value;
    }

    public static Atm get(String value) {
        return Atm.get(Token.token(value));
    }

    public static Atm get(byte[] value) {
        return value.length == 0 ? EMPTY : new Atm(value);
    }

    @Override
    public byte[] string(InputInfo ii) {
        return this.value;
    }

    public int hashCode() {
        return Token.hashCode(this.value);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.value.length != 0;
    }

    @Override
    public boolean comparable(Item item) {
        return item.type.isStringOrUntyped();
    }

    @Override
    public boolean equal(Item item, Collation coll, InputInfo ii) throws QueryException {
        return this.comparable(item) ? Token.eq(this.value, item.string(ii), Collation.get(coll, ii)) : item.equal(this, coll, ii);
    }

    @Override
    public boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        return this.comparable(item) && Token.eq(this.string(deep.info), item.string(deep.info), deep);
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        return this.comparable(item) ? Token.compare(this.value, item.string(ii), Collation.get(coll, ii)) : -item.compare(this, coll, transitive, ii);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Item expr = this;
        if (mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE)) {
            expr = Bln.get(this != EMPTY);
        }
        return cc.simplify(this, expr, mode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Atm)) return false;
        Atm atm = (Atm)obj;
        if (!Token.eq(this.value, atm.value)) return false;
        return true;
    }

    @Override
    public String toJava() {
        return Token.string(this.value);
    }

    @Override
    public void toString(QueryString qs) {
        qs.quoted(this.value);
    }
}

