/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.Duration;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ADateDur;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public class Dur
extends ADateDur {
    static final String DP = "(\\d+)";
    public static final Pattern YMD = Pattern.compile("(-?)P((\\d+)Y)?((\\d+)M)?");
    public static final Pattern DTD = Pattern.compile("(-?)P((\\d+)D)?(T((\\d+)H)?((\\d+)M)?((\\d+(\\.\\d+)?)S)?)?");
    public static final Pattern DUR = Pattern.compile("(-?)P((\\d+)Y)?((\\d+)M)?((\\d+)D)?(T((\\d+)H)?((\\d+)M)?((\\d+(?:\\d*\\.\\d+)?)?S)?)?");
    long months;
    BigDecimal seconds;

    public Dur(byte[] value, InputInfo info) throws QueryException {
        this(value, AtomType.DURATION, info);
    }

    Dur(Type type) {
        super(type);
    }

    public Dur(Dur dur) {
        this(dur, AtomType.DURATION);
    }

    private Dur(Dur dur, Type type) {
        this(type);
        this.months = dur.months;
        this.seconds = dur.seconds == null ? BigDecimal.ZERO : dur.seconds;
    }

    private Dur(byte[] value, Type type, InputInfo info) throws QueryException {
        this(type);
        String val = Token.string(value).trim();
        Matcher mt = DUR.matcher(val);
        if (!mt.matches() || Strings.endsWith(val, 'P') || Strings.endsWith(val, 'T')) {
            throw this.dateError(value, "P2000Y12MT23H12M34S", info);
        }
        this.yearMonth(value, mt, info);
        this.dayTime(value, mt, 6, info);
    }

    final void yearMonth(byte[] vl, Matcher mt, InputInfo info) throws QueryException {
        long y = mt.group(2) != null ? this.toLong(mt.group(3), true, info) : 0L;
        long m = mt.group(4) != null ? this.toLong(mt.group(5), true, info) : 0L;
        this.months = y * 12L + m;
        double v = (double)y * 12.0 + (double)m;
        if (!mt.group(1).isEmpty()) {
            this.months = -this.months;
            v = -v;
        }
        if (v <= -9.223372036854776E18 || v >= 9.223372036854776E18) {
            throw QueryError.DURRANGE_X_X.get(info, this.type, vl);
        }
    }

    final void dayTime(byte[] value, Matcher match, int pos, InputInfo info) throws QueryException {
        double v;
        long d = match.group(pos) != null ? this.toLong(match.group(pos + 1), true, info) : 0L;
        long h = match.group(pos + 3) != null ? this.toLong(match.group(pos + 4), true, info) : 0L;
        long m = match.group(pos + 5) != null ? this.toLong(match.group(pos + 6), true, info) : 0L;
        BigDecimal s = match.group(pos + 7) != null ? this.toDecimal(match.group(pos + 8), true, info) : BigDecimal.ZERO;
        this.seconds = s.add(BigDecimal.valueOf(d).multiply(Dec.BD_864000)).add(BigDecimal.valueOf(h).multiply(Dec.BD_3600)).add(BigDecimal.valueOf(m).multiply(Dec.BD_60));
        if (!match.group(1).isEmpty()) {
            this.seconds = this.seconds.negate();
        }
        if ((v = this.seconds.doubleValue()) <= -9.223372036854776E18 || v >= 9.223372036854776E18) {
            throw QueryError.DURRANGE_X_X.get(info, this.type, value);
        }
    }

    @Override
    public final long yea() {
        return this.months / 12L;
    }

    @Override
    public final long mon() {
        return this.months % 12L;
    }

    @Override
    public final long day() {
        return this.seconds.divideToIntegralValue(Dec.BD_864000).longValue();
    }

    @Override
    public final long hour() {
        return this.tim() / 3600L;
    }

    @Override
    public final long minute() {
        return this.tim() % 3600L / 60L;
    }

    @Override
    public final BigDecimal seconds() {
        return this.seconds.remainder(Dec.BD_60);
    }

    public long ms(InputInfo info) throws QueryException {
        BigDecimal ms = this.seconds.multiply(Dec.BD_1000);
        if (ms.compareTo(Dec.BD_MAXLONG) > 0) {
            throw QueryError.INTRANGE_X.get(info, ms);
        }
        return ms.longValue();
    }

    private long tim() {
        return this.seconds.remainder(Dec.BD_864000).longValue();
    }

    @Override
    public byte[] string(InputInfo ii) {
        TokenBuilder tb = new TokenBuilder();
        int ss = this.seconds.signum();
        if (this.months < 0L || ss < 0) {
            tb.add(45);
        }
        this.date(tb);
        this.time(tb);
        if (this.months == 0L && ss == 0) {
            tb.add("T0S");
        }
        return tb.finish();
    }

    @Override
    public final boolean comparable(Item item) {
        return item instanceof Dur;
    }

    final void date(TokenBuilder tb) {
        long d;
        long m;
        tb.add(80);
        long y = this.yea();
        if (y != 0L) {
            tb.addLong(Math.abs(y));
            tb.add(89);
        }
        if ((m = this.mon()) != 0L) {
            tb.addLong(Math.abs(m));
            tb.add(77);
        }
        if ((d = this.day()) != 0L) {
            tb.addLong(Math.abs(d));
            tb.add(68);
        }
    }

    final void time(TokenBuilder tb) {
        BigDecimal sc;
        long m;
        if (this.seconds.remainder(Dec.BD_864000).signum() == 0) {
            return;
        }
        tb.add(84);
        long h = this.hour();
        if (h != 0L) {
            tb.addLong(Math.abs(h));
            tb.add(72);
        }
        if ((m = this.minute()) != 0L) {
            tb.addLong(Math.abs(m));
            tb.add(77);
        }
        if ((sc = this.seconds()).signum() == 0) {
            return;
        }
        tb.add(Token.chopNumber(Token.token(sc.abs().toPlainString()))).add(83);
    }

    @Override
    public boolean equal(Item item, Collation coll, InputInfo ii) throws QueryException {
        Dur dur = (Dur)(item instanceof Dur ? item : this.type.cast(item, null, ii));
        return this.months == dur.months && this.seconds.compareTo(dur.seconds) == 0;
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        throw QueryError.compareError(item, this, ii);
    }

    @Override
    public final Duration toJava() {
        return ADate.DF.newDuration(Token.string(this.string(null)));
    }

    public final int hashCode() {
        return (int)((double)(31L * this.months) + (this.seconds == null ? 0.0 : this.seconds.doubleValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Dur)) return false;
        Dur dur = (Dur)obj;
        if (!this.type.eq(dur.type)) return false;
        if (this.months != dur.months) return false;
        if (!this.seconds.equals(dur.seconds)) return false;
        return true;
    }

    @Override
    public final void toString(QueryString qs) {
        qs.quoted(this.string(null));
    }
}

