/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.net.URI;
import javax.xml.catalog.CatalogFeatures;
import javax.xml.catalog.CatalogManager;
import javax.xml.transform.URIResolver;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.util.Reflect;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;

public final class Resolver {
    private static final String RESOLVER = "org.xmlresolver.Resolver";
    private static final String CONFIGURATION = "org.xmlresolver.XMLResolverConfiguration";

    private Resolver() {
    }

    public static EntityResolver entities(MainOptions mopts) {
        return (EntityResolver)Resolver.resolver(mopts);
    }

    public static URIResolver uris(MainOptions mopts) {
        return (URIResolver)Resolver.resolver(mopts);
    }

    public static LSResourceResolver resources(MainOptions mopts) {
        return (LSResourceResolver)Resolver.resolver(mopts);
    }

    private static Object resolver(MainOptions mopts) {
        String catalog = mopts.get(MainOptions.CATALOG);
        if (!catalog.isEmpty()) {
            if (Reflect.available(RESOLVER, new Object[0])) {
                Class<?> resolver = Reflect.find(RESOLVER);
                Class<?> configuration = Reflect.find(CONFIGURATION);
                Object conf = Reflect.get(Reflect.find(configuration, String.class), catalog);
                return Reflect.get(Reflect.find(resolver, configuration), conf);
            }
            URI uri = URI.create(IO.get(catalog).url());
            CatalogFeatures cf = CatalogFeatures.defaults();
            return CatalogManager.catalogResolver(CatalogManager.catalog(cf, uri));
        }
        return null;
    }
}

