/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.concurrent.atomic.AtomicInteger;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryString;
import org.basex.query.expr.AFilter;
import org.basex.query.expr.Expr;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.XQStruct;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class StructFilter
extends AFilter {
    public StructFilter(InputInfo info, Expr root, Expr ... preds) {
        super(info, Types.FUNCTION_O, root, preds);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        Expr expr = this.root;
        if (expr instanceof StructFilter) {
            StructFilter filter = (StructFilter)expr;
            this.root = filter.root;
            this.exprs = ExprList.concat(filter.exprs, this.exprs);
        }
        if (this.root == XQArray.empty() || this.root == XQMap.empty()) {
            return cc.replaceWith(this, this.root);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        QueryFocus qf;
        Item item = this.root.item(qc, this.info);
        if (item.isEmpty()) {
            return item;
        }
        if (!(item instanceof XQStruct)) {
            throw QueryError.STRUCT_FILTER_X.get(this.info, item);
        }
        QueryFocus focus = qc.focus;
        qc.focus = qf = new QueryFocus();
        try {
            for (Expr expr : this.exprs) {
                qf.size = item.structSize();
                AtomicInteger a = new AtomicInteger();
                if (item instanceof XQArray) {
                    ArrayBuilder ab = new ArrayBuilder(qc);
                    for (Value value2 : ((XQArray)item).iterable()) {
                        qc.checkStop();
                        qf.value = value2;
                        qf.pos = a.incrementAndGet();
                        if (!expr.test(qc, this.info, a.get())) continue;
                        ab.add(value2);
                    }
                    item = ab.array(this);
                    continue;
                }
                MapBuilder mb = new MapBuilder();
                XQMap map = (XQMap)item;
                map.forEach((key, value) -> {
                    qc.checkStop();
                    qf.value = new MapBuilder(2L).put((Item)Str.KEY, (Value)key).put((Item)Str.VALUE, (Value)value).map();
                    qf.pos = a.incrementAndGet();
                    if (expr.test(qc, this.info, a.get())) {
                        mb.put((Item)key, (Value)value);
                    }
                });
                item = mb.map(this);
            }
            Item item2 = item;
            return item2;
        }
        finally {
            qc.focus = focus;
        }
    }

    @Override
    protected Expr type(Expr expr, boolean optimize) {
        this.exprType.assign(this.root.seqType());
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof StructFilter)) return false;
        StructFilter sf = (StructFilter)obj;
        if (!this.root.equals(sf.root)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new StructFilter(this.info, this.root, this.exprs));
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.root).token('?');
        super.toString(qs);
    }
}

