/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value;

import org.basex.query.QueryContext;
import org.basex.query.expr.Expr;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.SeqBuilder;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.seq.tree.TreeSeqBuilder;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Util;
import org.basex.util.list.BoolList;
import org.basex.util.list.DoubleList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class ValueBuilder {
    private final QueryContext qc;
    private SeqBuilder builder;
    private final long capacity;
    private Value single;

    public ValueBuilder(QueryContext qc) {
        this(qc, -1L);
    }

    public ValueBuilder(QueryContext qc, long capacity) {
        this.qc = qc;
        this.capacity = capacity;
    }

    public ValueBuilder add(Value value) {
        if (!value.isEmpty()) {
            this.qc.checkStop();
            if (this.builder == null) {
                Value sngl = this.single;
                if (sngl == null) {
                    this.single = value;
                    return this;
                }
                this.single = null;
                this.builder = this.capacity == Long.MIN_VALUE ? new TreeSeqBuilder() : (ValueBuilder.isStr(sngl) && ValueBuilder.isStr(value) ? new StrSeqBuilder() : (ValueBuilder.isAtm(sngl) && ValueBuilder.isAtm(value) ? new AtmSeqBuilder() : (ValueBuilder.isInt(sngl) && ValueBuilder.isInt(value) ? new IntSeqBuilder() : (ValueBuilder.isDbl(sngl) && ValueBuilder.isDbl(value) ? new DblSeqBuilder() : (ValueBuilder.isBln(sngl) && ValueBuilder.isBln(value) ? new BlnSeqBuilder() : new ItemSeqBuilder())))));
                this.add(sngl);
            }
            this.builder = this.builder.add(value, this.qc);
        }
        return this;
    }

    public Value value() {
        return this.value(AtomType.ITEM);
    }

    public Value value(Type type) {
        try {
            Value value = this.builder != null ? this.builder.value(type) : (this.single != null ? this.single : Empty.VALUE);
            return value;
        }
        finally {
            this.builder = null;
            this.single = null;
        }
    }

    public Value value(Expr expr) {
        return expr != null ? this.value(expr.seqType().type) : this.value();
    }

    static boolean isStr(Value value) {
        return value instanceof Str && value.type == AtomType.STRING;
    }

    static boolean isAtm(Value value) {
        return value.type == AtomType.UNTYPED_ATOMIC;
    }

    static boolean isInt(Value value) {
        return value.type == AtomType.INTEGER;
    }

    static boolean isDbl(Value value) {
        return value.type == AtomType.DOUBLE;
    }

    static boolean isBln(Value value) {
        return value.type == AtomType.BOOLEAN;
    }

    public String toString() {
        return Util.className(this) + "[" + Util.className(this.builder != null ? this.builder : (this.single != null ? this.single : Empty.VALUE)) + "]";
    }

    final class StrSeqBuilder
    extends SeqBuilder {
        private final TokenList values;

        StrSeqBuilder() {
            this.values = new TokenList(ValueBuilder.this.capacity);
        }

        @Override
        public SeqBuilder add(Item item) {
            if (ValueBuilder.isStr(item)) {
                this.values.add(((Str)item).string());
                return this;
            }
            return this.tree(item, ValueBuilder.this.qc);
        }

        @Override
        public Value value(Type type) {
            return StrSeq.get(this.values);
        }
    }

    final class AtmSeqBuilder
    extends SeqBuilder {
        private final TokenList values;

        AtmSeqBuilder() {
            this.values = new TokenList(ValueBuilder.this.capacity);
        }

        @Override
        public SeqBuilder add(Item item) {
            if (ValueBuilder.isAtm(item)) {
                this.values.add(((Atm)item).string(null));
                return this;
            }
            return this.tree(item, ValueBuilder.this.qc);
        }

        @Override
        public Value value(Type type) {
            return StrSeq.get(this.values, (Type)AtomType.UNTYPED_ATOMIC);
        }
    }

    final class IntSeqBuilder
    extends SeqBuilder {
        private final IntList values;

        IntSeqBuilder() {
            this.values = new IntList(ValueBuilder.this.capacity);
        }

        @Override
        public SeqBuilder add(Item item) {
            int i;
            if (ValueBuilder.isInt(item) && (i = ((Itr)item).toInt()) != Integer.MIN_VALUE) {
                this.values.add(i);
                return this;
            }
            return this.tree(item, ValueBuilder.this.qc);
        }

        @Override
        public Value value(Type type) {
            return IntSeq.get(this.values.finish());
        }
    }

    final class DblSeqBuilder
    extends SeqBuilder {
        private final DoubleList values;

        DblSeqBuilder() {
            this.values = new DoubleList(ValueBuilder.this.capacity);
        }

        @Override
        public SeqBuilder add(Item item) {
            if (ValueBuilder.isDbl(item)) {
                this.values.add(((Dbl)item).dbl());
                return this;
            }
            return this.tree(item, ValueBuilder.this.qc);
        }

        @Override
        public Value value(Type type) {
            return DblSeq.get(this.values.finish());
        }
    }

    final class BlnSeqBuilder
    extends SeqBuilder {
        private final BoolList values;

        BlnSeqBuilder() {
            this.values = new BoolList(ValueBuilder.this.capacity);
        }

        @Override
        public SeqBuilder add(Item item) {
            if (ValueBuilder.isBln(item)) {
                this.values.add(((Bln)item).bool(null));
                return this;
            }
            return this.tree(item, ValueBuilder.this.qc);
        }

        @Override
        public Value value(Type type) {
            return BlnSeq.get(this.values.finish());
        }
    }

    final class ItemSeqBuilder
    extends SeqBuilder {
        private final ItemList items;

        ItemSeqBuilder() {
            this.items = new ItemList(ValueBuilder.this.capacity);
        }

        @Override
        public SeqBuilder add(Item item) {
            this.items.add(item);
            return this;
        }

        @Override
        public Value value(Type type) {
            return this.items.value(type);
        }
    }
}

