NAME
    RISCOS::Colour -- conversions between RISC OS colour values and
    arrays

SYNOPSIS
        use RISCOS::Units qw(unpack_colour);
        $col = unpack_colour ($packed);
        print "Red = $$col[0]; Green = $$col[1]; $Blue = $$col[2]\n";


DESCRIPTION
    This module provides conversion functions between arrays of RGB
    values and 32 bit integers used by RISC OS to store colours.

    pack_colour <colour>, ...
        `pack_colour' packs integers or arrays of RGB triples into 4
        bytes as used in blocks passed to RISC OS SWIs. `undef' maps
        to -1 ('`'') which is used in DrawFiles to mean
        transparent, integers are taken to be a single colour of the
        form 0xBBGGRR00, scalar references are assumed to be already
        packed, and array references are assumed to point to 3
        integers (red,green,blue) in the rage 0 - 255. To convert
        a single colour call in scalar conted:

            $colour = pack_colour [1, 0, 1];
            # Pack magenta, passing ref to an anonyomous hash


        To convert a list call in list context:

            ($fore, $back) = pack_colour([0,0,0], [255, 255, 255])
            # Black on white


    unpack_colour <colour>, ...
        `unpack_clour' converts 4 byte colours to arrays of RGB
        values. When called in scalar context a single array
        reference is returned for the first argument. When called in
        list context an <array of array references> is returned.

            ($fore, $back) = unpack_colour ($fore_raw, $back_raw);
            print "Red = $$fore[0]; Green = $$fore[1]; $Blue = $$fore[2]\n";


BUGS
    Not tested enough yet.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

